#Inserting libraries
library(quantmod)
library(lubridate)
library(ggplot2)
library(Metrics)
library(splines)
library(forecast)
library(tseries)
library(rugarch)
library(mosaic)
library(calculus)

#Stock.csv contains all the Sensex and Nifty values (open,high,low,close) from 1st Jan 2019 till 20th May 2020

#The following code stores only the Sensex values (only open) along with the date into dataframe tempS and timeS contains the time series data.

stock<-read.csv("Stock.csv")
date=stock$Date
date=dmy(date)
stock[,1]=date
dataS<-data.frame(stock[,1],stock[,6])
names(dataS)[1]<-"Date"
names(dataS)[2]<-"Sensex"
timeS<-xts(dataS[,-1],order.by = dataS[,1])

index<-c(1:length(timeS))

#The following code stores only the Nifty values (only open) along with the date into dataframe tempN and timeN contains the time series data.

dataN<-data.frame(stock[,1],stock[,2])
names(dataN)[1]<-"Date"
names(dataN)[2]<-"Nifty"
timeN<-xts(dataN[,-1],order.by = dataN[,1])

#Viewing data
head(dataS)
tail(dataS)

head(dataN)
tail(dataN)

#Converting to time series
library(quantmod)
timeS<-xts(dataS[,-1],order.by = dataS[,1])
timeN<-xts(dataN[,-1],order.by = dataN[,1])

par(mar=c(4,4,2,3))
plot(x=date,y=dataN$Nifty,type='l',col='red',xlab="Time",ylab="Nifty values",cex.axis=0.8,main = "Stock Market Analysis")
par(new=TRUE)
plot(x=date,y=dataS$Sensex,type='l',col='blue',xlab="",ylab="",xaxt='n',yaxt='n')
axis(4)
mtext("Sensex values",side=4,line=2)
legend("bottomleft",legend=c("Nifty","Sensex"),col=c('red','blue'),lwd=2)

#Summary of data
summary(dataS$Sensex)
summary(dataN$Nifty)



#Applying spline regression using the knots points in array points. The values in points are the index of the values chosen. They will be same for Nifty and Sensex.
#This is for Sensex and this will be similarly be applied for Nifty

point<-c(1,29,91,177,181,189,282,305,311,327,339) #knot points
dataS<-data.frame(index,dataS)

for (i in c(1:(length(point)-1))) {
  fit<-lm(dataS[point[i]:point[i+1],3]~((I(dataS[point[i]:point[i+1],1])+I(dataS[point[i]:point[i+1],1]^2)+I(dataS[point[i]:point[i+1],1]^3))))
  
  #print(fit$coefficients)  will be used to form the equations of the fitted curves
  
  dataS[point[i]:point[i+1],4]<-fit$fitted
  dataS[point[i]:point[i+1],5]<-fit$residuals
}
names(dataS)[4]<-"Fit"
names(dataS)[5]<-"Res"
dataS$points<-NA
dataS[point,6]<-dataS[point,3]


#Plotting both the Sensex and Nifty fitted models together with knot points

par(mar=c(4,4,2,3))
plot(x=date,y=dataS$Sensex,type='l',col='red',xlab="Time",ylab="Nifty values",cex.axis=0.8,main = "Knot Points Chosen")
points(x=dataS$Date,y=dataS$points,pch=16)
par(new=TRUE)
plot(x=date,y=dataN$Nifty,type='l',col='blue',xlab="",ylab="",xaxt='n',yaxt='n')
axis(4)
mtext("Sensex values",side=4,line=2)
legend("bottomleft",legend=c("Nifty","Sensex"),col=c('red','blue'),lwd=2)


point<-c(1,29,91,177,181,189,282,305,311,327,339) #Knot points by index number
dataN<-data.frame(index,dataN)

for (i in c(1:(length(point)-1))) {
  fit2<-lm(dataN[point[i]:point[i+1],3]~((I(dataN[point[i]:point[i+1],1])+I(dataN[point[i]:point[i+1],1]^2)+I(dataN[point[i]:point[i+1],1]^3))))
  #print(fit2$coefficients)
  
  dataN[point[i]:point[i+1],4]<-fit2$fitted
  dataN[point[i]:point[i+1],5]<-fit2$residuals
}
names(dataN)[4]<-"Fit"
names(dataN)[5]<-"Res"
dataN$points<-NA
dataN[point,6]<-dataN[point,3]




#Writing the respective coefficients in a tabular form

ind<-c(1:(length(point)-1))
coeff2<-data.frame(ind)
coeff2[,2]<-c(fit2$coefficients[1],1.378081e+04,-1.882056e+04,4.612642e+08,5.536569e+05,-2.904332e+04,-8.821558e+06,-7.431767e+08,-4.887070e+07,9.419958e+07)
coeff2[,3]<-c(3.714412e+01,-2.108956e+02,7.156223e+02,-7.739206e+06,-1.008447e+04,4.645525e+02,8.885148e+04,7.218807e+06,4.588170e+05,-8.482418e+05)
coeff2[,4]<-c(-3.260230e+00,4.592556e+00,-5.399194e+00,4.328166e+04,6.175447e+01,-1.732930e+00,-2.970629e+02,-2.337234e+04,-1.435558e+03,2.546241e+03)
coeff2[,5]<-c(7.994356e-02,-2.851471e-02,1.305044e-02,-8.067917e+01,-1.247896e-01,2.137055e-03,3.300245e-01,2.522361e+01,1.497179e+00,-2.547684e+00)
names(coeff2)[1]<-"Equation"
names(coeff2)[2]<-"Intercept"
names(coeff2)[3]<-"Degree1"
names(coeff2)[4]<-"Degree2"
names(coeff2)[5]<-"Degree3"
print(coeff2)

ind<-c(1:(length(point)-1))
coeff<-data.frame(ind)
coeff[,2]<-c(35697.6258739,48147.1174488,-5.469980e+04,1.605438e+09,-3.650485e+05,-1.158827e+05,-3.288133e+07,-2.576535e+09,-1.534222e+08,3.359342e+08)
coeff[,3]<-c(136.8887731,-820.8614388,2.179449e+03,-2.693054e+07,2.727266e+03,1.783014e+03,3.313964e+05,2.501869e+07,1.440811e+06,-3.025995e+06)
coeff[,4]<-c(-10.9543189,17.2460523,-1.631802e+01,1.505765e+05,6.828232e+00,-6.709182e+00,-1.109087e+03,-8.097587e+04,-4.509379e+03,9.086384e+03)
coeff[,5]<-c(0.2645245,-0.1051567,3.922962e-02,-2.806208e+02,-5.283670e-02,8.373018e-03,1.233731e+00,8.736028e+01,4.704413e+00,-9.094560e+00)
names(coeff)[1]<-"Equation"
names(coeff)[2]<-"Intercept"
names(coeff)[3]<-"Degree1"
names(coeff)[4]<-"Degree2"
names(coeff)[5]<-"Degree3"
print(coeff)


#Plotting fitted Sensex and original Sensex values wih Date
timeS<-xts(dataS[,3:4],order.by = dataS[,2])
plot(timeS)
addLegend(legend.loc = "bottomleft",legend.names=c("Actual","Pred","Residual"),lw=c(2,2,2),col=c("black","red","darkblue"))
timeS<-xts(dataS[,3:5],order.by=dataS[,2])
lines(timeS$Res, on=NA, col="darkblue")


#Plotting fitted Nifty and original Nifty values with Date 
timeN<-xts(dataN[,3:4],order.by = dataN[,2])
plot(timeN)
addLegend(legend.loc = "bottomleft",legend.names=c("Actual","Pred","Residual"),lw=c(2,2,2),col=c("black","red","darkblue"))
timeN<-xts(dataN[,3:5],order.by=dataN[,2])
lines(timeN$Res, on=NA, col="darkblue")



#Writing the expression based on the coefficients
f1<-expression(3.569763e+04+1.368888e+02*x-10.954319*x^2+2.645245e-01*x^3)
f2<-expression(4.814712e+04-8.208614e+02	*x+17.246052*x^2-1.051567e-01*x^3)
f3<-expression(-5.469980e+04+2.179449e+03*x-16.318020*x^2+3.922962e-02*x^3)
f4<-expression(1.605438e+09-2.693054e+07*x+150576.50*x^2-2.806208e+02*x^3)
f5<-expression(-3.650485e+05+2.727266e+03*x+6.828232*x^2-5.283670e-02*x^3)
f6<-expression(-1.158827e+05+1.783014e+03*x-6.709182*x^2+8.373018e-03*x^3)
f7<-expression(-3.288133e+07+3.313964e+05*x-1109.087000*x^2+1.233731e+00*x^3)
f8<-expression(-2.576535e+09+2.501869e+07*x-80975.870000*x^2+8.736028e+01*x^3)
f9<-expression(-1.534222e+08+1.440811e+06*x-4509.379000*x^2+4.704413e+00*x^3)
f10<-expression(3.359342e+08-3.025995e+06*x+9086.384000*x^2-9.094560e+00*x^3)

#Checking derievatives
e1<-as.character(D(f1,'x'))
e2<-as.character(D(f2,'x'))
e3<-as.character(D(f3,'x'))
e4<-as.character(D(f4,'x'))
e5<-as.character(D(f5,'x'))
e6<-as.character(D(f6,'x'))
e7<-as.character(D(f7,'x'))
e8<-as.character(D(f8,'x'))
e9<-as.character(D(f9,'x'))
e10<-as.character(D(f10,'x'))
eq<-data.frame(1:10,c(e1,e2,e3,e4,e5,e6,e7,e8,e9,e10))
eq
#Computing derivatives with the respective functions at the required intervals
fx1<-function(x)
{
  136.8888 - 10.954319 * (2 * x) + 0.2645245 * (3 * x^2)
}
fx2<-function(x)
{
  17.246052 * (2 * x) - 820.8614 - 0.1051567 * (3 * x^2)
}
fx3<-function(x)
{
  2179.449 - 16.31802 * (2 * x) + 0.03922962 * (3 * x^2)
}
fx4<-function(x)
{
  150576.5 * (2 * x) - 26930540 - 280.6208 * (3 * x^2)
}
fx5<-function(x)
{
  2727.266 + 6.828232 * (2 * x) - 0.0528367 * (3 * x^2)
}
fx6<-function(x)
{
  1783.014 - 6.709182 * (2 * x) + 0.008373018 * (3 * x^2)
}
fx7<-function(x)
{
  331396.4 - 1109.087 * (2 * x) + 1.233731 * (3 * x^2)
}
fx8<-function(x)
{
  25018690 - 80975.87 * (2 * x) + 87.36028 * (3 * x^2)
}
fx9<-function(x)
{
  1440811 - 4509.379 * (2 * x) + 4.704413 * (3 * x^2)
}
fx10<-function(x)
{
  9086.384 * (2 * x) - 3025995 - 9.09456 * (3 * x^2)
}

dataS$D1<-c(fx1(point[1]:(point[2]-1)),fx2(point[2]:(point[3]-1)),fx3(point[3]:(point[4]-1)),fx4(point[4]:(point[5]-1)),fx5(point[5]:(point[6]-1)),fx6(point[6]:(point[7]-1)),fx7(point[7]:(point[8]-1)),fx8(point[8]:(point[9]-1)),fx9(point[9]:(point[10]-1)),fx10(point[10]:point[11]))

f1<-expression(10736.54+3.714412e+01*x-3.260230*x^2+0.079943560*x^3)
f2<-expression(13780.81-2.108956e+02*x+4.592556*x^2-0.028514710*x^3)
f3<-expression(-18820.56+7.156223e+02*x-5.399194*x^2+0.013050440*x^3)
f4<-expression(461264200-7.739206e+06*x+43281.66*x^2-80.67917000*x^3)
f5<-expression(553656.90-1.008447e+04*x+61.754470*x^2-0.12478960*x^3)
f6<-expression(-29043.32+4.645525e+02*x-1.732930*x^2+0.002137055*x^3)
f7<-expression(-8821558+8.885148e+04	*x-297.062900*x^2+0.33002450*x^3)
f8<-expression(-743176700.00+7.218807e+06*x-23372.340*x^2+25.22361000*x^3)
f9<-expression(-48870700.00+4.588170e+05*x-1435.558000*x^2+1.497179000*x^3)
f10<-expression(94199580.00-8.482418e+05*x+2546.241000*x^2-2.5476840*x^3)

#Checking derievatives
D(f1,'x')
D(f2,'x')
D(f3,'x')
D(f4,'x')
D(f5,'x')
D(f6,'x')
D(f7,'x')
D(f8,'x')
D(f9,'x')
D(f10,'x')

fx1<-function(x)
{
  37.14412 - 3.26023 * (2 * x) + 0.07994356 * (3 * x^2)
}
fx2<-function(x)
{
  4.592556 * (2 * x) - 210.8956 - 0.02851471 * (3 * x^2)
}
fx3<-function(x)
{
  715.6223 - 5.399194 * (2 * x) + 0.01305044 * (3 * x^2)
}
fx4<-function(x)
{
  43281.66 * (2 * x) - 7739206 - 80.67917 * (3 * x^2)
}
fx5<-function(x)
{
  61.75447 * (2 * x) - 10084.47 - 0.1247896 * (3 * x^2)
}
fx6<-function(x)
{
  464.5525 - 1.73293 * (2 * x) + 0.002137055 * (3 * x^2)
}
fx7<-function(x)
{
  88851.48 - 297.0629 * (2 * x) + 0.3300245 * (3 * x^2)
}
fx8<-function(x)
{
  7218807 - 23372.34 * (2 * x) + 25.22361 * (3 * x^2)
}
fx9<-function(x)
{
  458817 - 1435.558 * (2 * x) + 1.497179 * (3 * x^2)
}
fx10<-function(x)
{
  2546.241 * (2 * x) - 848241.8 - 2.547684 * (3 * x^2)
}

dataN$D1<-c(fx1(point[1]:(point[2]-1)),fx2(point[2]:(point[3]-1)),fx3(point[3]:(point[4]-1)),fx4(point[4]:(point[5]-1)),fx5(point[5]:(point[6]-1)),fx6(point[6]:(point[7]-1)),fx7(point[7]:(point[8]-1)),fx8(point[8]:(point[9]-1)),fx9(point[9]:(point[10]-1)),fx10(point[10]:point[11]))


#First derivative plot
par(mar=c(4,4,2,3))
plot(x=date,y=dataN$D1,type='l',col='red',xlab="Time",ylab="Nifty values",cex.axis=0.8)
par(new=TRUE)
plot(x=date,y=dataS$D1,type='l',col='blue',xlab="",ylab="",xaxt='n',yaxt='n')
par(new=T)
axis(4)
mtext("Sensex values",side=4,line=2)
legend("bottomleft",legend=c("Nifty","Sensex"),col=c('red','blue'),lwd=2)



#Similarly for double derivatives
f1<-expression(136.8888 - 10.954319 * (2 * x) + 0.2645245 * (3 * x^2))
f2<-expression(17.246052 * (2 * x) - 820.8614 - 0.1051567 * (3 * x^2))
f3<-expression(2179.449 - 16.31802 * (2 * x) + 0.03922962 * (3 * x^2))
f4<-expression(150576.5 * (2 * x) - 26930540 - 280.6208 * (3 * x^2))
f5<-expression(2727.266 + 6.828232 * (2 * x) - 0.0528367 * (3 * x^2))
f6<-expression(1783.014 - 6.709182 * (2 * x) + 0.008373018 * (3 * x^2))
f7<-expression(331396.4 - 1109.087 * (2 * x) + 1.233731 * (3 * x^2))
f8<-expression(25018690 - 80975.87 * (2 * x) + 87.36028 * (3 * x^2))
f9<-expression(1440811 - 4509.379 * (2 * x) + 4.704413 * (3 * x^2))
f10<-expression(9086.384 * (2 * x) - 3025995 - 9.09456 * (3 * x^2))

D(f1,'x')
D(f2,'x')
D(f3,'x')
D(f4,'x')
D(f5,'x')
D(f6,'x')
D(f7,'x')
D(f8,'x')
D(f9,'x')
D(f10,'x')

#Similarly for double derivative

fx1<-function(x)
{
  0.2645245 * (3 * (2 * x)) - 10.954319 * 2
}
fx2<-function(x)
{
  17.246052 * 2 - 0.1051567 * (3 * (2 * x))
}
fx3<-function(x)
{
  0.03922962 * (3 * (2 * x)) - 16.31802 * 2
}
fx4<-function(x)
{
  150576.5 * 2 - 280.6208 * (3 * (2 * x))
}
fx5<-function(x)
{
  6.828232 * 2 - 0.0528367 * (3 * (2 * x))
}
fx6<-function(x)
{
  0.008373018 * (3 * (2 * x)) - 6.709182 * 2
}
fx7<-function(x)
{
  1.233731 * (3 * (2 * x)) - 1109.087 * 2
}
fx8<-function(x)
{
  87.36028 * (3 * (2 * x)) - 80975.87 * 2
}
fx9<-function(x)
{
  4.704413 * (3 * (2 * x)) - 4509.379 * 2
}
fx10<-function(x)
{
  9086.384 * 2 - 9.09456 * (3 * (2 * x))
}

dataS$D2<-c(fx1(point[1]:(point[2]-1)),fx2(point[2]:(point[3]-1)),fx3(point[3]:(point[4]-1)),fx4(point[4]:(point[5]-1)),fx5(point[5]:(point[6]-1)),fx6(point[6]:(point[7]-1)),fx7(point[7]:(point[8]-1)),fx8(point[8]:(point[9]-1)),fx9(point[9]:(point[10]-1)),fx10(point[10]:point[11]))


f1<-expression(37.14412 - 3.26023 * (2 * x) + 0.07994356 * (3 * x^2))
f2<-expression(4.592556 * (2 * x) - 210.8956 - 0.02851471 * (3 * x^2))
f3<-expression(715.6223 - 5.399194 * (2 * x) + 0.01305044 * (3 * x^2))
f4<-expression(43281.66 * (2 * x) - 7739206 - 80.67917 * (3 * x^2))
f5<-expression(61.75447 * (2 * x) - 10084.47 - 0.1247896 * (3 * x^2))
f6<-expression(464.5525 - 1.73293 * (2 * x) + 0.002137055 * (3 * x^2))
f7<-expression(88851.48 - 297.0629 * (2 * x) + 0.3300245 * (3 * x^2))
f8<-expression(7218807 - 23372.34 * (2 * x) + 25.22361 * (3 * x^2))
f9<-expression(458817 - 1435.558 * (2 * x) + 1.497179 * (3 * x^2))
f10<-expression(2546.241 * (2 * x) - 848241.8 - 2.547684 * (3 * x^2))

D(f1,'x')
D(f2,'x')
D(f3,'x')
D(f4,'x')
D(f5,'x')
D(f6,'x')
D(f7,'x')
D(f8,'x')
D(f9,'x')
D(f10,'x')

fx1<-function(x)
{
  0.07994356 * (3 * (2 * x)) - 3.26023 * 2
}
fx2<-function(x)
{
  4.592556 * 2 - 0.02851471 * (3 * (2 * x))
}
fx3<-function(x)
{
  0.01305044 * (3 * (2 * x)) - 5.399194 * 2
}
fx4<-function(x)
{
  43281.66 * 2 - 80.67917 * (3 * (2 * x))
}
fx5<-function(x)
{
  61.75447 * 2 - 0.1247896 * (3 * (2 * x))
}
fx6<-function(x)
{
  0.002137055 * (3 * (2 * x)) - 1.73293 * 2
}
fx7<-function(x)
{
  0.3300245 * (3 * (2 * x)) - 297.0629 * 2
}
fx8<-function(x)
{
  25.22361 * (3 * (2 * x)) - 23372.34 * 2
}
fx9<-function(x)
{
  1.497179 * (3 * (2 * x)) - 1435.558 * 2
}
fx10<-function(x)
{
  2546.241 * 2 - 2.547684 * (3 * (2 * x))
}

dataN$D2<-c(fx1(point[1]:(point[2]-1)),fx2(point[2]:(point[3]-1)),fx3(point[3]:(point[4]-1)),fx4(point[4]:(point[5]-1)),fx5(point[5]:(point[6]-1)),fx6(point[6]:(point[7]-1)),fx7(point[7]:(point[8]-1)),fx8(point[8]:(point[9]-1)),fx9(point[9]:(point[10]-1)),fx10(point[10]:point[11]))




#Second derivative plot
par(mar=c(4,4,2,3))
plot(x=date,y=dataN$D2,type='l',col='red',xlab="Time",ylab="Nifty values",cex.axis=0.8,main = "Second Derivatives")
par(new=TRUE)
plot(x=date,y=dataS$D2,type='l',col='blue',xlab="",ylab="",xaxt='n',yaxt='n')
par(new=T)
axis(4)
mtext("Sensex values",side=4,line=2)
legend("bottomleft",legend=c("Nifty","Sensex"),col=c('red','blue'),lwd=2)




#ACF and PACF plots
Acf(dataS$Res,100)  # 100 is the lag value
Pacf(dataS$Res,100)
Acf(dataN$Res,100)  
Pacf(dataN$Res,100)

#Selecting best GARCH model
library(GEVStableGarch)
gsSelect(dataS$Res,order.max=c(1,1,1,1),cond.dist = "norm",selection.criteria = "AIC")


#AR+GARCH model for Sensex
spec<-ugarchspec(variance.model = list(garchOrder=c(1,1)),mean.model = list(armaOrder=c(1,0,0)))
spec_fitS<-ugarchfit(spec,dataS$Res)
spec_fitS


#Plotting the fit of the residuals of GARCH model with the actual Sensex residual values
par(mar=c(4,4,2,3))
plot(x=date,y=dataS$Res,type='l',col='red',xlab="Time",ylab="Original",cex.axis=0.8,main = "Residual Analysis")
par(new=TRUE)
plot(x=date,y=spec_fitS@fit$fitted.values,type='l',col='blue',xlab="",ylab="",xaxt='n',yaxt='n')
axis(4)
mtext("Fitted",side=4,line=2)
legend("bottomleft",legend=c("Sensex Residuals","GARCH Fitted Values"),col=c('red','blue'),lwd=2)

#AR+GARCH model for Nifty
spec<-ugarchspec(variance.model = list(garchOrder=c(1,1)),mean.model = list(armaOrder=c(1,0,0)))
spec_fitN<-ugarchfit(spec,dataN$Res)
spec_fitN

#Plotting the fit of the residuals of GARCH model with the actual Nifty residual values
par(mar=c(4,4,2,3))
plot(x=date,y=dataN$Res,type='l',col='red',xlab="Time",ylab="Original",cex.axis=0.8,main = "Residual Analysis")
par(new=TRUE)
plot(x=date,y=spec_fitN@fit$fitted.values,type='l',col='blue',xlab="",ylab="",xaxt='n',yaxt='n')
axis(4)
mtext("Fitted",side=4,line=2)
legend("bottomleft",legend=c("Nifty Residuals","GARCH Fitted Values"),col=c('red','blue'),lwd=2)
