rm(list=ls())
#Insert Data into AppData dataset
App <- c ("Flow Free","Zombie Catchers","Gems or jewels ?","Candy Crush Jelly Saga","Jewels Star: OZ adventure","Hungry Shark Evolution","Pdf Book Download ","Free Book Reader","eBoox new","Golden Dictionary (EN-AR)","All Language Translator Free","Azpen eReader","ADP Mobile Solutions","OfficeSuite","Job Search by ZipRecruiter","Google Primer","SuperLivePro","TED","English Communication","Khan Academy","Learn English with Wlingua","Princess Coloring Book","English Grammar Test","Speed Reading","English for beginners")
Category <- c ("GAME","GAME","GAME","GAME","GAME","GAME","BOOKS","BOOKS","BOOKS","BOOKS","BOOKS","BOOKS","BUSINESS","BUSINESS","BUSINESS","BUSINESS","BUSINESS","EDUCATION","EDUCATION","EDUCATION","EDUCATION","EDUCATION","EDUCATION","EDUCATION","EDUCATION")
Rating <- c(4.3,4.7,3.7,4.3,2.5,4.5,4.4,3.4,4.9,4.4,3.4,3.5,1.3,4.3,4.8,2.4,4.3,3.6,4.7,4.6,2.7,4.5,1.8,4.6,2.6)
Reviews <- c(1295625,990796,171448,1300619,21892,6074627,1322,1680,2739,51269,30105,156,85185,1002861,148945,62272,46353,181893,2544,85375,314299,9770,4075,10611,9321)
Size.mb <- c(11,75,13,78,14,100,3.5,4,21,6.1,2.1,42,29,35,25,18,21,18,18,21,3.3,39,5.1,11,27)
AppData <- data.frame(App,Category,Rating,Reviews,Size.mb)
View(AppData)

# Create .csv file
write.csv(AppData,"NewAppData.csv")
NewAppData <- read.csv("NewAppData.csv")
print(NewAppData)

#Que  1.	Install package ggplot and import it
install.packages("ggplot2")
library(ggplot2)

#que 2.	Draw pie chat for showing size require for different education application
subset.data.frame(AppData,Category=="EDUCATION")

x <- c (18,18,21,3.3,39,5.1,11,27)
labels <- c("TED","English Communication","Khan Academy","Learn English with Wlingua","Princess Coloring Book","English Grammer Test","Speed Reading","English for beginners") 
pieper <- round(100 * x/sum(x),1)
pie(x,labels,main = "Education pie chart",col = rainbow(length(x)))


#Que 3.	Draw histogram for ratings of e-books apps with proper labeling.
subset.data.frame(AppData,Category=="BOOKS")
v <- c(4.4,3.4,4.9,4.4,3.4,3.5)
hist(v,xlab = "Ratings of e-books apps ",col = "green",border = "blue",main = "Histogram of E-book rating")

#Que 4.	Draw bar chart for showing app-wise rating with proper labeling.
barplot(AppData$Rating,ylab = "App Rating",xlab = "App Name",main = "bar chart for showing app-wise rating",col = "pink",names.arg = AppData$App)

#Que 5.	Reveal the relationship between rating and reviews of business apps
subset.data.frame(AppData,Category=="BUSINESS")

Rating <- c (1.3,4.3,4.8,2.4,4.3)
Reviews <- c(85185,1002861,148945,62272,46353)
cor.test(Rating, Reviews)

#Que 6.	Draw bar char for showing category wise application count
table(Category)
count=table(Category)
barplot(count,main = "bar char for showing category wise application count",col = blues9,ylab = "Count Number",xlab = "Category Name")

#Que 7.	Find the frequency distribution of app category.
AppCategoryData <- read.table("NewAppData.csv",header = TRUE,sep = ",")
AppCategoryScore <- AppData$Category
transform(table(AppCategoryScore))

#Que 8.	Draw bar graph for showing rating of education system.
subset.data.frame(AppData,Category=="EDUCATION")
R <- c(3.6,4.7,4.6,2.7,4.5,1.8,4.6,2.6)
labels <- c("TED"," English Communication","Khan Academy","Learn English with Wlingua","Princess Coloring Book","English Grammar Test","Speed Reading","English for beginners")
barplot(R,names.arg = labels, ylab = "Education App Rating",xlab = "Apps Name", main = "bar graph for showing rating of education system",col = "red")

#Que 9.	Find the relative frequency distribution of app categories
rf <- table(AppData$Category)/length(AppData$Category)
print(rf)

#Que 10.	Draw the scatter plot of reviews and rating given to education app. Does it revels the relationship between variables? If yes which type of relationship
View(AppData)
dim(AppData)

subset.data.frame(AppData,Category=="EDUCATION")
Education_App_Rating <- c(3.6,4.7,4.6,2.7,4.5,1.8,4.6,2.6)
Education_App_Review <- c(181893,2544,85375,314299,9770,4075,10611,9321)
plot(x=Education_App_Rating,y=Education_App_Review,main = " Scatter plot of Education app reviews and rating",col="red")

cor.test(AppData$Rating,AppData$Reviews)

#Que 11.	Find the cumulative frequency distribution of the rating in AppStore
cumsum(AppData$Rating)

#Que 12.	Determine total number of applications having rating below 3.5.
#Display all information about app having rating below 3.5
subset(AppData,Rating < 3.5)

#Disply total number of applications having rating below 3.5

count=table(AppData$Rating < 3.5)
print(count)




