#Author: Dr.R.Maheswari,Professor, School of Computing Science & Engineering, VIT Chennai
#Ex1- Drinking water analysis, monitoring and forecasting.
#R version 4.1.2 (2021-11-01)
#RStudio version 1.2.1335

#Program Execution

#1. Importing dataset and plotting values as a timeseries

df1 <- read.csv("C:\\Users\\Lenovo\\waterdata.csv")
time_series <- ts(df1$Water,frequency=1, start=c(1885))
time_series
plot.ts(time_series)

#2 Plotting Logarithmic timeseries

log_series <- log(time_series)
log_series
plot.ts(log_series)

#3 Simple Moving Average(SMA)

library("TTR")
SMA_series <- SMA(time_series,n=3)
plot.ts(SMA_series)

#4 Holt-Winters filtering

time_series_forecasts <- HoltWinters(time_series, beta=FALSE, gamma=FALSE)
time_series_forecasts
time_series_forecasts$fitted
plot(time_series_forecasts)

#5 Forecasting

time_series_forecasts$SSE
HoltWinters(time_series, beta=FALSE, gamma=FALSE, l.start=23.56)

#6 MannKendall

library(Kendall)
MannKendall(time_series)
plot(time_series)
lines(lowess(time(time_series),time_series), col='blue')

#7 Decomposition of Additive timeseries

time_series <- ts(df1$Water,frequency=12, start=c(1885))
time_series_components <- decompose(time_series)
time_series_components$seasonal 
plot(time_series_components)

#8 ts2df

library(wql)
ts2df(time_series, mon1 = 1, addYr = FALSE, omit = FALSE)


#Conclusion
#Drinking water analysis, monitoring and forecasting was done successfully using R.

