#ANOVA

#To clear the environment
rm(list=ls())

#Import the required libraries
library(dplyr)
library("ggplot2")
library("readxl")

#Import and load the dataset
data <- read_excel("liquid.xls")

#To find grand mean, and mean of thermal conductivity
mean_analytical <- mean(data$`K analytical`)
mean_analytical
mean_experimental <- mean(data$`K experimental`)
mean_experimental
grand_mean <- ((8*mean_analytical)+(8*mean_experimental))/16
grand_mean

#Sum of Squares between and Sum of Squares within
SSC <- (8*((mean_analytical-grand_mean)^2))+(8*((mean_experimental-grand_mean)^2))
SSC   #sum of squares between
SSE <- sum((data$`K analytical`-mean_analytical)^2)+sum((data$`K experimental`-mean_experimental)^2)
SSE   #sum of squares within

#Degrees of Freedom (Between, Within and total)
C <- 2
N <- 16
df_between <- (C-1)
df_between
df_within <- (N-C)
df_within
df_total <- (N-1)
df_total

#Mean Squares (Between and Within)
MSC <- SSC/df_between
MSC   #mean squares between
MSE <- SSE/df_within
MSE   #mean squares within

#F_Statistic and F Critical
F_Statistic <- MSC/MSE
F_Statistic
F_Critical <- qf(p=0.05,df1=df_between,df2=df_within,lower.tail=FALSE)
F_Critical

#Is Null hypothesis accepted?
if(F_Statistic<F_Critical){
  print("Null hypothesis is accepted")
} else {
  print("Null hypothesis is rejected")
}

#To plot Vol. Concentration VS Thermal Conductivity
ggplot()+geom_line(aes(x=data$`Vol Concentration`,y=data$`K analytical`), color="blue")+geom_line(aes(x=data$`Vol Concentration`,y=data$`K experimental`),color="red")+xlab('Volume Concentration')+ylab('Thermal Conductivity')

#To plot Vol Concentration Vs % increase in Thermal conductivity
par(mfrow=c(2,2))
barplot(data$`%Increase in K analytical`, names.arg = data$`Vol Concentration`, xlab ="Volume Concentration", ylab ="Increase in Thermal Conductivity Analytical",col="blue")
barplot(data$`%Increase in K experimental`, names.arg = data$`Vol Concentration`, xlab ="Volume Concentration", ylab ="Increase in Thermal Conductivity Experimental",col="red")

#Error (Measured Value-Analytical Value)
sum(data$`K experimental`-data$`K analytical`)   #sum of error
s <- sum((data$`K experimental`-data$`K analytical`)^2)
s/8   #mean squared error