#Time Series Forecasting

#Import the required libraries
library(forecast)
library(tseries)
library("anytime")

#Import and load the dataset
data <- read.csv('monthly-sunspots.csv')

#Display head of dataset
head(data)

#Convert data type into Date type
data$Month <- anydate(data$Month)
data$Month <- as.Date(data$Month)

#Check for unfilled data
sum(is.na(data))

#Statistical info
summary(data)

plot(data,type="l")

#Plot as timeseries data
tsdata <- ts(data$Sunspots,frequency=12)
plot(tsdata)

#Decompose the data as multiplicative
ddata <- decompose(tsdata,"multiplicative")

plot(ddata)

plot(ddata$trend)
plot(ddata$seasonal)
plot(ddata$random)

#ADF test for stationarity
adf.test(data$Sunspots)

autoplot(acf(data,plot=FALSE))
autoplot(pacf(data,plot=FALSE))

#Model using ARIMA
auto.arima(data$Sunspots)