#KNN Classifier

#To clear the environment
rm(list=ls())

#Importing the libraries
library(class)

#Load and view information about the dataset
mydata=iris
head(mydata)
str(mydata)

#Split the dataset into training and testing data
index=sample(2,nrow(mydata),replace=TRUE,prob=c(0.7,0.3))
training=mydata[index==1,]
testing=mydata[index==2,]

#Feature scaling
training_scale <- scale(training[,1:4])
testing_scale <- scale(testing[,1:4])

#Fitting KNN Model to training data
KNNM <- knn(train=training_scale,test=testing_scale,cl=training$Species,k=1)
plot(KNNM)

#Confusion matrix
CFM <- table(testing$Species,KNNM)
CFM

#Accuracy of model
misClassError <- mean(KNNM!=testing$Species)
print(paste('Accuracy =',1-misClassError))

#When k=3
KNNM <- knn(train=training_scale,test=testing_scale,cl=training$Species,k=3)
misClassError <- mean(KNNM!=testing$Species)
print(paste('Accuracy =',1-misClassError))

#When k=5
KNNM <- knn(train=training_scale,test=testing_scale,cl=training$Species,k=5)
misClassError <- mean(KNNM!=testing$Species)
print(paste('Accuracy =',1-misClassError))

#When k=7
KNNM <- knn(train=training_scale,test=testing_scale,cl=training$Species,k=7)
misClassError <- mean(KNNM!=testing$Species)
print(paste('Accuracy =',1-misClassError))

#When k=15
KNNM <- knn(train=training_scale,test=testing_scale,cl=training$Species,k=15)
misClassError <- mean(KNNM!=testing$Species)
print(paste('Accuracy =',1-misClassError))