#Social Network Analysis

#Name: Remita Austin
#Faculty Mentor: Dr. Parvathi R

#To clear the environment
rm(list=ls())

#Import the required libraries
library(sna)
library(igraph)

#Import and load the dataset
d <- read.csv('socialnetworkdata.csv')
data <- data.frame(d$first,d$second)
str(data)

#To create the network
network <- graph.data.frame(data)
V(network)  #vertices
E(network)  #edges
degree(network)  #degree of each node in graph
betweenness(network)  #betweenness of each node
V(network)$label <- V(network)$name  #using names as labels
V(network)$degree <- degree(network)

#To plot the histogram of node degree
hist(V(network)$degree,main='Histogram of node degree',xlab='Degree of vertices',ylab='Frequency')

#Plotting the network diagram
plot(network,vertex.label.cex=0.7,vertext.size=2,edge.arrow.size=0.1)

#To calculate the Hub score and Authority score
hs <- hub_score(network)$vector
hs
as <- authority.score(network)$vector
as
plot(network,vertex.size=hs*30,main='Hubs',edge.arrow.size=0.1,layout=layout.fruchterman.reingold)

plot(network,vertex.size=as*30,main='Authorities',edge.arrow.size=0.1,layout=layout.fruchterman.reingold)

#To detect groups of densely connected nodes known as communities
network <- graph.data.frame(data,directed=F)
cnetwork <- cluster_edge_betweenness(network)
plot(cnetwork,network,vertex.label.cex=0.7)