#Author: Dr.Pattabiraman.V, Professor, School of Computing Science & Engineering, VIT Chennai
#Ex5 - Visualization of Subgroups and Communities in a Network using Igraph 
#R version 3.6.2 (2019-12-12)
#RStudio version 1.2.1335
library(igraph)
g4 <- graph( c('Susann', 'Jeag4te', 'Harrison', 'Myron', 'Julie', 'Colten', 'Brandyn', 'Leland', 'Catherine', 'Tracy', 'Bee', 'Maureen', 'Annika', 'Hans', 'Spenser', 'Angelo', 'Blanche', 'Stanford', 'Hope', 'Catherine', 'Almira', 'Thomas', 'Henry', 'Ralph', 'Louvenia', 'German', 'Lura', 'Wilma', 'Lauretta', 'Maudie', 'Martha', 'Henry', 'Loyd', 'Mayra', 'Noelle', 'Fabian', 'Ira', 'Zenobia', 'Noelle', 'Natalie', 'Brooke', 'German', 'Lauretta', 'Zenobia', 'Hallie', 'Braxton', 'Lorraine', 'Alicia', 'Allie', 'Jaylon', 'Myrna', 'Darrel', 'Lura', 'Hermon', 'Wyatt', 'Raoul', 'Althea', 'Laurel', 'Leola', 'Darrel', 'Giles', 'Merritt', 'Angelo', 'Kendrick', 'Travis', 'Henry', 'Owen', 'Almira', 'Michelle', 'Lou', 'Stephan', 'Leola', 'Wyatt', 'Allie', 'Eli', 'Brandyn', 'Mayra', 'Chin', 'Clarance', 'Marlee', 'Glenn', 'Reid', 'Glenn', 'Jerrold', 'Dale', 'Helena', 'Alvie', 'Elden', 'Chaim', 'Merritt', 'Augustine', 'Curtiss', 'Alvie', 'Allie', 'Pollie', 'Catherine', 'Angelita', 'Glenn', 'Allie', 'Braden', 'Manford', 'Raoul', 'Dwight', 'Pollie', 'Zona', 'Reggie', 'Dominic', 'Amy', 'Santos', 'Faron', 'Leslie', 'Etha', 'Maureen', 'Juanita', 'Gust', 'Noelle', 'Darrel', 'Darin', 'Faron', 'Zona', 'Myron', 'Hans', 'German', 'Elden', 'Mayra', 'Merritt', 'Myron', 'Gerald', 'Andrea', 'German', 'Angelita', 'Giles', 'Reggie', 'Wyatt', 'Alvie', 'Darrel', 'Jarrett', 'Newell', 'Brandyn', 'Eloisa', 'Santos', 'Lou', 'Quintin', 'Zechariah', 'Leola', 'Anthony', 'Eliga', 'Gust', 'Obie', 'Obie', 'Brandyn', 'Brooke', 'Dominic', 'Jacoby', 'Maureen', 'Hardie', 'Noelle', 'Braxton', 'Noelle', 'Leola', 'Marlee', 'Helena', 'Ira', 'Kermit', 'Wilda', 'Eli', 'Chance', 'Hardie', 'Andrea', 'Johnnie', 'Lauretta', 'Tracy', 'Kathryn', 'Spenser', 'Lou', 'Dana', 'Dominic', 'Rachelle', 'Glenn', 'Darrel', 'Deidra', 'Orpha', 'Hermon', 'Rosalind', 'Hans', 'Curtis', 'Josue', 'Wyatt', 'Agatha', 'Wyatt', 'Chance', 'Glenn', 'Kendrick', 'Brooke', 'Hollie', 'Beverly', 'Katarina', 'Josue', 'Leslie', 'Colten', 'Mayra', 'Darin', 'Hermon', 'Myron', 'Alicia', 'Leila', 'Kermit', 'Lamar', 'Dana', 'Johnnie', 'Althea', 'Judson', 'Colten', 'Hope', 'Gust', 'Clarance', 'Leland', 'Matthew', 'Lorraine', 'Althea', 'Colten', 'Jewel', 'Leila', 'Eli', 'Zenobia', 'German', 'Jaylon', 'Henry', 'Michelle', 'Johnie', 'Judson', 'Johnnie', 'Leslie', 'Wyatt', 'Lou', 'Maureen', 'Jacoby', 'Noelle', 'Johnnie', 'Alvie', 'Leila', 'Myron', 'Wilda', 'Brandyn', 'Kendrick', 'Gerald', 'Tyson', 'Jacoby', 'Ari', 'Theo', 'Harrison', 'Carmen', 'Leonard', 'Braden', 'Desi', 'Zona', 'Maureen', 'Ralph', 'Thomas', 'Myron', 'Austin', 'Leola', 'Loyd', 'Quintin', 'Lorraine', 'Glenn', 'Merritt', 'Janet', 'Myron', 'Alicia', 'Maureen', 'Leslie', 'Carla', 'Vicky', 'Harley', 'Leslie', 'Hannah', 'Gust', 'Andrea', 'Giles', 'Wilma', 'Henry', 'Hermon', 'Stefani', 'Henry', 'Harley', 'Noelle', 'Kermit', 'Laurel', 'Hermon', 'Sebastian', 'Andrea', 'Eliga', 'Sigmund', 'Darrel', 'Noelle', 'Urban', 'Almira', 'Noelle', 'Dwight', 'Beverly', 'Wyatt', 'Juanita', 'Reid', 'Kermit', 'Myrna', 'Pollie', 'Hope', 'Leola', 'Leslie', 'Jacoby', 'Pollie', 'Tiffany', 'Gust', 'Leland', 'Eliga', 'Lamar', 'Ira', 'Dale', 'Noelle', 'Jarrett', 'Zenobia', 'Orpha', 'Glenn', 'Amy', 'Hermon', 'Myrna', 'Brandyn', 'Nell', 'Leslie', 'Edd', 'Lura', 'Kendrick', 'Obie', 'Augustine', 'Zona', 'Glenn', 'Dominic', 'Jennifer', 'Rachelle', 'Faron', 'Darrel', 'Pollie', 'Almira', 'Glenn', 'Wilma', 'Angus', 'Leila', 'Sherri'))
V(g4)$name
V(g4)$part <- c('teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student')
E(g4)$type <- "knows" 
g4 <- set.edge.attribute(g4, "weight", value=runif(ecount(g4)))


net.sym <- as.undirected(g4, mode= "collapse",
                         edge.attr.comb=list(weight="sum", "ignore"))

cliques(net.sym) # list of cliques
sapply(cliques(net.sym), length) # clique sizes
largest_cliques(net.sym) # cliques with max number of nodes
vcol <- rep("grey80", vcount(net.sym))
vcol[unlist(largest_cliques(net.sym))] <- "gold"
plot(as.undirected(net.sym), vertex.label=V(net.sym)$name, vertex.color=vcol,vertex.label.cex= 0.6)



ceb <- cluster_edge_betweenness(g4) 
dendPlot(ceb, mode="hclust")
plot(ceb, g4, edge.arrow.size=.2, vertex.label.color="black", vertex.label.dist=0.1,vertex.size=6,vertex.label.cex=0.8)
class(ceb)
length(ceb) # number of communities
membership(ceb) # community membership for each node
modularity(ceb) # how modular the graph partitioning is
crossing(ceb, g4) # boolean vector: TRUE for edges across communities



clp <- cluster_label_prop(g4) 
plot(clp, g4, edge.arrow.size=.05,vertex.label.cex= 0.6)


cfg <- cluster_fast_greedy(as.undirected(g4))
plot(cfg, as.undirected(g4), vertex.label.cex=0.5, edge.arrow.size=.05)


library("RColorBrewer")
V(g4)$community <- cfg$membership
colrs <- adjustcolor( col=brewer.pal(n = 10, name = "Accent"))
plot(g4, vertex.color=colrs[V(g4)$community],vertex.label.cex= 0.6, edge.arrow.size=.05)

kc <- coreness(g4, mode="all")
plot(g4, vertex.size=kc*10, vertex.label=kc, vertex.color=colrs[kc],edge.arrow.size=.05)




