# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.11 on Pg 503
# Test Marketing of Package Designs, Part 3

# Aim is to find 95% confidence interval estimate of p1 - p2 
# p1 : proportion of brightly colored design
# p2 : proportion of simple green design

data1 <- read.csv(file.choose()) #choose Xm13-09.csv
names(data1)

soap1 <- data1$Supermarket.1
soap2 <- data1$Supermarket.2

#Counting the number of successes i.e., number of 9077 brand in both samples
code9077_1 <- length(which(soap1 == 9077)) #Answer: 180
code9077_2 <- length(which(soap2 == 9077)) #Answer: 155

n1 <- length(soap1) #Answer: 904
n2 <- length(soap2) #Answer: 1038

#Comparing two population proportions i.e., two-sample Z test using prop.test() function
chitest <-prop.test(c(180,155),c(904,1038), correct = FALSE)

lcl = chitest$conf.int[1] #Answer: 0.0159
ucl = chitest$conf.int[2] #Answer: 0.0837

cat("The 95% confidence interval estimate of p1 - p2: ", "(", round(lcl,4), ",", round(ucl,4), ")")

#End
