# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.5 on Pg. 478
# Comparing Salary Offers for Finance and Marketing MBA Majors, Part 2 


data1 <- read.csv(file.choose()) #choose Xm13-05.csv

finance <- data1$Finance
marketing <- data1$Marketing

#paired t-test using the paired=TRUE in function t.test() 

t <- t.test(finance, marketing, paired = TRUE, alternative = "two.sided")

cat("The t-test statistic,", t$statistic, "> than", qt(0.95, df=t$parameter)) 
#qt() gives the tabulated t-critical value at specified df and level of significance

if(t$p.value < 0.05)
{
  print("It can be infered that finance majors obtain higher salary offers than marketing majors.")
} else 
{
  print("There is NOT enough evidence to infer that finance majors obtain higher salary offers than marketing majors.")
}

#End
