# Statistics for Management and Economics by Gerald Keller
# Chapter 11: Introduction to Hypothesis Testing
# Example 11.2 on Pg 377
# Comparison of AT&T and Its Competitor 


data1 <- read.csv(file.choose()) #choose Xm11-02.csv

names(data1) #gives list of variables in the dataset

bill <- data1$Bills

#Given
mean_population_bill = 17.09
sd_population_bill = 3.87

mean_sample_bill = mean(bill) #mean of the sample dataset
#Answer: 17.5499

install.packages("BSDA")
library(BSDA)
z.test(bill, y = NULL, alternative = "two.sided", mu = mean_population_bill, 
       sigma.x = sd_population_bill, sigma.y = NULL, conf.level = 0.95)


# Answer:
# One-sample z-Test

# z = 1.1884, p-value = 0.2347
# alternative hypothesis: true mean is not equal to 17.09
# 95 percent confidence interval: (16.79139 18.30841)

#End
