# Statistics for Management and Economics by Gerald Keller
# Chapter 3: Graphical Descriptive Techniques II
# Example 3.1 on Pg 45
# Analysis of Long-Distance Telephone Bills 

data1 <- read.csv(file.choose()) #choose Xm03-01.csv

names(data1) #dataset variable is Bills
bill <- data1$Bills
range(bill) #data range: 0 to 119

#seq() function used to generate a sequence 0 to 120 
breaks = seq(0, 120, by=15)

#cut() function in R divides the dataset into intervals
bill.cut <- cut(bill, breaks, right=FALSE)

cbind(table(bill.cut)) #gives the frequency table as per intervals 

#Histogram
hist(bill, labels = TRUE, xlab = "Long Distance Phone bills", main = 'Histogram of Bills')

#End
