# Statistics for Management and Economics by Gerald Keller
# Chapter 16: SIMPLE LINEAR REGRESSION AND CORRELATION
# Example 16.4 on Pg 654
# Are Odometer Reading and Price of Used Toyota Camrys Related? 

data1 <- read.csv(file.choose()) #choose Xm16-02.csv

Odometer <- data1$Odometer #number of miles in 1000 mi on odometer - Explanatory variable
Price <- data1$Price #Price in 1000$ - Respone variable

#Aim is to determine whether there is enough evidence in Example 16.2 
#to conclude that there is a linear relationship between the auction price and 
#the odometer reading for the sample of 100 3-year-old Toyota Camrys. 

regression_line <- lm(Price ~ Odometer) #gives regression line
s <- summary(regression_line) #gives the Residuals, Std Error etc
s$coef[2,"t value"] #t-statistic for odometer is -13.44
s$coef[2,"Pr(>|t|)"]#very low p-value < 0.05  

if(s$coef[2,"Pr(>|t|)"] > 0.05)
{
  print("There is NOT enough evidence that odometer reading plays a role in changing judgement about auction price.")
} else 
{
  print("There is enough evidence that odometer reading plays a role in changing judgement about auction price.")
}


#End


