# Statistics for Management and Economics by Gerald Keller
# Chapter 4: Numerical Descriptive Techniques
# Example 4.17 on Pg 134
# Estimating Fixed and Variable Costs 

data1 <- read.csv(file.choose()) #choose Xm04-17.csv

options(digits=5) #for decimal control

Elec_costs <- data1$Electrical.costs #response variable
tool <- data1$Number.of.tools #independent variable

#regression model using least squares
reg_model <- lm(Elec_costs~tool)
print(summary(reg_model), digits=2)

cat("The least squares line is: Electricity Cost =", 
    reg_model$coefficients[1], "+", reg_model$coefficients[2], "* Number of Tools")

cat("Fixed cost is $", round(reg_model$coefficients[1], digits=4), "and variable cost is",
    round(reg_model$coefficients[2], digits=4), "$")

#Scatter plot with fitted line and equation
plot(tool, Elec_costs, pch=18, col="blue", main ='Scatter plot of Electricity Cost vs Number of Tools')
abline(coefficients(reg_model), lwd=2, lty=2, col="red")
eq <- paste("Electricity Cost =", round(reg_model$coefficients[2], digits=3), "* Number of Tools", 
            "+", reg_model$coefficients[1])
mtext(eq, side=3, line=-1)
mtext("R-Square value:", side=1, line=-4)
mtext(round(summary(reg_model)$r.squared, digits=3), side=1, line=-3)

#Answer: Fixed cost is 9.58 dollars and variable cost is 2.25 dollars.

#End
