# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.4 on Pg. 475
# Comparing Salary Offers for Finance and Marketing MBA Majors, Part 1 

data1 <- read.csv(file.choose()) #choose Xm13-04.csv

finance <- data1$Finance
marketing <- data1$Marketing

#t-test with pooled variance
t <- t.test(finance, marketing, var.equal = TRUE, alternative = "greater")

cat("The t-test statistic,", t$statistic, "is < than", qt(0.95, df=t$parameter)) 
#qt() gives the tabulated t-critical value at specified df and level of significance

if(t$p.value < 0.05)
{
  print("There is enough evidence to support the hypothesis that finance majors receive higher salary offers than marketing majors.")
} else 
{
  print("There is very little evidence to support the hypothesis that finance majors receive higher salary offers than marketing majors.")
}

#End