# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.2 on Pg. 458
# Effect of New CEO in Family-Run Businesses 

data1 <- read.csv(file.choose()) #choose Xm13-02.csv
names(data1)

offspring <- data1$Offspring
outsider <- data1$Outsider


######F-test to test if variances are equal or not
#### using var.test() function
f <- var.test(offspring, outsider, alternative = "two.sided")

#tabulated F value at given dfs and alpha=0.025
#qf() function gives the tabulated F-crtitcal value at specified dfs and level of significance
table_f <- qf(0.025, df1=f$parameter[1], df2 = f$parameter[2])

cat("The F-test statistic,", f$statistic, "is < than tabulated F", table_f) 

if(f$p.value < 0.05)
{
  print("There is enough evidence to infer that the population variances differ.
The appropriate technique is the unequal-variances t-test.")
} else 
{
  print("There is NOT enough evidence to infer that the population variances differ.")
}


######t-test with unequal variances (two-sided)
#### using t.test() function
t<-t.test(offspring,outsider, var.equal = FALSE, alternative = "two.sided")

cat("The t-test statistic,", t$statistic, "is < than", qt(0.95, df=t$parameter)) 
#qt() gives the tabulated t-crtitcal value at specified df and level of significance

if(t$p.value < 0.05)
{
  print("There is sufficient evidence to infer that the mean changes in operating income differ.")
} else 
{
  print("There is NO sufficient evidence to infer that the mean changes in operating income differ.")
}

#End