# Statistics for Management and Economics by Gerald Keller
# Chapter 16: SIMPLE LINEAR REGRESSION AND CORRELATION
# Example 16.7a on Pg 667
# Predicting the Price and Estimating the Mean Price of Used Toyota Camrys


data1 <- read.csv(file.choose()) #choose Xm16-02.csv

Odometer <- data1$Odometer #number of miles in 1000 mi on odometer - Explanatory variable
Price <- data1$Price #Price in 1000$ - Respone variable

#prediction intervals of expected value 
regression_line <- lm(Price ~ Odometer) #gives regression line
s<-summary(regression_line) #gives the Residuals, Std Error etc

new.dat <- data.frame(Odometer=40) #predict selling price at 40 Miles odometer reading for one particular car
pred <- predict(regression_line, newdata = new.dat, interval = 'prediction')

cat("The lower and upper limits of the 95% prediction interval at 40 miles are",
    pred[2]*1000, "$ and", pred[3]*1000, "$.")

#End
