# Statistics for Management and Economics by Gerald Keller
# Chapter 15: CHI-SQUARED TESTS
# Example 15.2 on Pg 604
# Relationship between Undergraduate Degree and MBA Major 

data1 <- read.csv(file.choose()) #choose Xm15-02.csv

UG_deg <- data1$Degree
MBA_major <- data1$MBA.Major

contingency_table <- ftable(MBA_major ~ UG_deg)
summary(contingency_table)

#Null Hypothesis, Ho:  The two variables, undergraduate degree and MBA major, are independent 

chi <- chisq.test(contingency_table, p = c(61/152, 44/152, 47/152))
chi$statistic
chi$p.value #its less than 0.05 implying one can reject the Null hypothesis

tabchi <- qchisq(.95, df=6) #degrees of freedom is (4-1)(3-1) = 6
tabchi

if(chi$statistic > tabchi)
{
  print("There is enough evidence of a relationship between undergraduate degree and MBA major.")
} else 
{
  print("There is NOT enough evidence of a relationship between undergraduate degree and MBA major.")
}
#End
