# Statistics for Management and Economics by Gerald Keller
# Chapter 16: SIMPLE LINEAR REGRESSION AND CORRELATION
# Example 16.6 on Pg 661
# Are Odometer Reading and Price of Used Toyota Camrys Linearly Related? Testing the Coefficient of Correlation 

data1 <- read.csv(file.choose()) #choose Xm16-02.csv

Odometer <- data1$Odometer #number of miles in 1000 mi on odometer - Explanatory variable
Price <- data1$Price #Price in 1000$ - Respone variable

#test the correlation betwen auction price and odometer readings

correlation_coeff <- cor(Price, Odometer) #gives the correlation coefficient between selling price and odometer readings
sig <- cor.test(Price, Odometer)# t-test for testing the significance of the correlation

cat("The coefficient of correlation is:", correlation_coeff)

if(sig$statistic < qt(0.025,98))
{
  print("The correlation coefficient is insignificant.")
} else 
{
  print("The correlation coefficient is significant.")
}

#End