# Statistics for Management and Economics by Gerald Keller
# Chapter 12: INFERENCE ABOUT A POPULATION
# Example 12.1 on Pg 400
# Newspaper Recycling Plant 

data1 <- read.csv(file.choose()) #choose Xm12-01.csv
names(data1)
head(data1)
  
#One-sample t-test (one-sided)
result <- t.test(data1$Newspaper, mu=2, alternative="greater", conf.level=0.99)
#Answer:One Sample t-test
#data:  data1$Newspaper
#t = 2.2369, df = 147, p-value = 0.0134
#alternative hypothesis: true mean is greater than 2
#99 percent confidence interval:
#  1.990716      Inf


if(result$p.value > 0.01)
{
  print("At 1% level of significance, there is NOT enough evidence to infer that the mean weight of 
        discarded newspapers is greater than 2.0")
} else 
{
  print("There is enough evidence to infer that the mean weight of discarded newspapers is greater than 2.0")
}
#End