# Statistics for Management and Economics by Gerald Keller
# Chapter 13: INFERENCE ABOUT COMPARING TWO POPULATIONS
# Example 13.1 on Pg. 453
# Direct and Broker-Purchased Mutual Funds 


data1 <- read.csv(file.choose()) #choose Xm13-01.csv
names(data1)

direct <- data1$Direct
broker <- data1$Broker

######F-test to test if variances are equal or not
#### using var.test() function
f <- var.test(direct, broker, alternative = "two.sided")

#tabulated F value at given dfs and alpha1=0.025, alpha2=0.975
#qf() function gives the tabulated F-crtitcal value at specified dfs and level of significance
table_f1 <- qf(0.975, df1 = f$parameter[1], df2 = f$parameter[2])
table_f2 <- qf(0.025, df1 = f$parameter[1], df2 = f$parameter[2])

cat("The F-test statistic,", round(f$statistic,2), "is not greater than,", round(table_f1,2), 
    ",nor smaller than", round(table_f2,2), "Thus, we cannot reject the null hypothesis.")

if(f$p.value < 0.05)
{
  print("There is enough evidence to infer that the population variances differ.")
} else 
{
  print("There is NOT enough evidence to infer that the population variances differ.
    The appropriate technique is the equal-variances t-test.")
}

######t-test with EQUAL variances (one-sided)#### using t.test() function
t<-t.test(direct,broker, var.equal = TRUE, alternative = "greater")

cat("The t-test statistic,", round(t$statistic,2), "> than",  qt(0.95, df=t$parameter))  
#qt() gives the tabulated t-crtitcal value at specified df and level of significance

if(t$p.value < 0.05)
{
  print("There is sufficient evidence to infer that on average directly purchased mutual funds outperform broker-purchased mutual funds.")
} else 
{
  print("There is NO sufficient evidence to infer that on average directly purchased mutual funds outperform broker-purchased mutual funds.")
}
 
#confidence limits
t1 <- t.test(direct,broker, var.equal = TRUE, alternative = "two.sided")
lcl <- t1$conf.int[1]
ucl <- t1$conf.int[2]

cat("The 95% confidence interval estimate of the difference between 
    the return for directly purchased mutual funds and the mean return for broker-purchased mutual funds is:",
    "(", round(lcl,2), ",", round(ucl,2), ")")
#Answer: (0.39, 5.43)

#End