# Statistics for Management and Economics by Gerald Keller
# Chapter 14: ANALYSIS OF VARIANCE
# Example 14.5 on Pg 581
# Causes of Variation

data1 <- read.csv(file.choose()) #choose Xm14-05.csv
names(data1)
typeof(data1$rodlength) #Double
typeof(data1$machine) #Integer
typeof(data1$operator) #Integer
typeof(as.character(data1$machine)) #character

#two-way ANOVA with interaction
anova(lm(rodlength ~ as.character(operator) + as.character(machine) + 
           as.character(operator):as.character(machine), data1))

#Answer:
#Analysis of Variance Table
#Response: rodlength
#                                             Df   Sum Sq   Mean Sq F value   Pr(>F)   
#as.character(operator)                        2 0.015133 0.0075663  6.9850 0.002175 **
#as.character(machine)                         3 0.003363 0.0011212  1.0350 0.385551   
#as.character(operator):as.character(machine)  6 0.004646 0.0007744  0.7149 0.639358   
#Residuals                                    48 0.051995 0.0010832 


#End