# Statistics for Management and Economics by Gerald Keller
# Chapter 4: Numerical Descriptive Techniques
# Example 4.19 on Pg 148
# Market Model for Research in Motion 

data1 <- read.csv(file.choose()) #choose Xm04-19.csv

options(digits=5) #for decimal control

rimm <- data1$RIMM #response variable
index <- data1$Index #independent variable

#Regression model
reg_model <- lm(rimm~index)
print(summary(reg_model), digits=2)

#Scatter plot with fitted line and equation
plot(index, rimm, pch=18, col="blue", main ='Scatter plot of monthly rates of return for Research in Motion (RIMM) and the NASDAQ index')
abline(coefficients(reg_model), lwd=2, lty=2, col="black")
eq <- paste("RIMM =", round(reg_model$coefficients[2], digits=4), "* NASDAQ Index", 
            "+", round(reg_model$coefficients[1], digits=4))
mtext(eq, side=3, line=-1)
mtext("R-Square value:", side=1, line=-4)
mtext(round(summary(reg_model)$r.squared, digits=3), side=1, line=-3)

#Interpretation: for each 1% increase in NASDAQ index, 1.9204% is the average increase in RIMM's return
#We see that the return on investing in Research in Motion is more fluctuating 
#and hence riskier than NASDAQ

#End