# Statistics for Management and Economics by Gerald Keller
# Chapter 14: ANALYSIS OF VARIANCE
# Example 14.2b on Pg 544
# Comparing the Costs of Repairing Car Bumpers


data1 <- read.csv(file.choose()) #choose Xm14-02.csv
names(data1)

repair_cost <- data1$repair_cost
bumper <- data1$bumper

oneway_anova <- summary(aov(repair_cost~bumper))
#Answer:

#Df Sum Sq Mean Sq F value Pr(>F)  
#bumper       3 150884   50295   4.056 0.0139 *
#Residuals   36 446368   12399 

#Applying Fisher's Least Significant Difference (LSD) Method 
install.packages("agricolae")
library(agricolae)
lsd <- LSD.test(repair_cost, bumper, MSerror = 12399, DFerror = 36, alpha = 0.05, p.adj=c("none"))
#Answer: LSD statistic: 100.9942
#Answer is slightly different from the book:101.09


#Applying Bonferroni Adjustment to LSD Method
bonferr <- LSD.test(repair_cost, bumper, MSerror = 12399, DFerror = 36, alpha = 0.05, p.adj=c("bonferroni"))
#Answer after Bonferroni adjustment: 139.0335
#Answer is slightly different from the book:139.13


#Applying Tukey's Multiple Comparison Method 
tukey <- TukeyHSD((aov(repair_cost~bumper)))
#Answer:  Tukey multiple comparisons of means
#95% family-wise confidence level

#Fit: aov(formula = repair_cost ~ bumper)

#$bumper
        #diff     lwr        upr       p adj
#B2-B1  105.9  -28.21684 240.016839 0.1641025
#B3-B1  103.8  -30.31684 237.916839 0.1775400
#B4-B1  -31.8 -165.91684 102.316839 0.9188067
#B3-B2   -2.1 -136.21684 132.016839 0.9999725
#B4-B2 -137.7 -271.81684  -3.583161 0.0423300
#B4-B3 -135.6 -269.71684  -1.483161 0.0466876


#Interpretations:
#Using the Bonferroni adjustment of Fisher's LSD method, we discover that none of the bumpers differ.
#Tukey's method tells us that bumper 4 differs from both bumpers 2 and 3. 
#Hence, Bumper 4 appears to have the lowest cost of repair. 

#End
