# Statistics for Management and Economics by Gerald Keller
# Chapter 4: Numerical Descriptive Techniques
# Example 4.6 on Pg 102
# Mode of Long-Distance Bill 

data1 <- read.csv(file.choose()) #choose Xm03-01.csv

names(data1)

Bill <- data1$Bills

# there is no inbuilt function for calculating Mode
# So, a function is written to compute Mode. It works if the data is numeric.
# It creates a frequency table using the function table() and gives the index of the value occuring maximum
# times using the function which.max().
Mode <- function(x) 
{
  if (is.numeric(x)) 
  {
    x_table <- table(x)
    return(as.numeric(names(x_table)[which.max(x_table)]))
  }
}

tB <- table(Bill)
names(tB)
which.max(tB)
names(tB)[which.max(tB)]

Mode(Bill)

#Answer: sample mode is 0

#End