# Statistics for Management and Economics by Gerald Keller
# Chapter 11: Introduction to Hypothesis Testing
# Example 11.1 on Pg 365
# Department Store's New Billing System 


data1 <- read.csv(file.choose()) #choose Xm11-01.csv

names(data1) #gives list of variables in the dataset

Acc <- data1$Accounts

#Given
mean_population_acc = 170
sd_population_acc = 65

mean_sample_Acc = mean(Acc) #mean of the sample dataset
#Answer: 177.9965

install.packages("BSDA")
library(BSDA)
z.test(Acc, y = NULL, alternative = "greater", mu = mean_population_acc, 
       sigma.x = sd_population_acc, sigma.y = NULL, conf.level = 0.95)

#One-sample z-Test

#z = 2.4605, p-value = 0.006938
#alternative hypothesis: true mean is greater than 170
#95 percent confidence interval: (172.650, NA)

#End
