#page 62-63
library(ggplot2)
consumer<-data.frame(year=c(2003,2004,2005,2006,2007,2008,2009,2010,2011,2012),
         jan=c(181.7,185.2,190.7,198.3,202.416,211.080,211.143,216.687,220.223,226.665),
         feb=c(183.1,186.2,191.8,198.7,203.499,211.693,212.193,216.741,221.309,227.663),
         mar=c(184.2,187.4,193.3,199.8,205.352,213.528,212.709,217.631,223.467,229.392),
         apr=c(183.8,188,194.6,201.5,206.686,214.823,213.24,218.009,224.906,230.085),
         may=c(183.5,189.1,194.4,202.5,207.949,216.632,213.856,218.178,225.964,229.815),
         jun=c(183.7,189.7,194.5,202.9,208.352,218.815,215.693,217.965,225.722,229.478),
         jul=c(183.9,189.4,195.4,203.5,208.299,219.964,215.351,218.011,225.922,229.104),
         aug=c(184.6,189.5,196.4,203.9,207.917,219.086,215.834,218.312,226.545,230.379),
         sep=c(185.2,189.9,198.8,202.9,208.49,218.783,215.969,218.439,226.889,231.407),
         oct=c(185,190.9,199.2,201.8,208.936,216.573,216.177,218.711,226.421,231.317),
         nov=c(184.5,191,197.6,201.5,210.177,212.425,216.33,218.803,226.23,230.221),
         dec=c(184.3,190.3,196.8,201.8,210.036,210.228,215.949,219.179,225.672,229.601),
         annual=c(184,188.9,195.3,201.6,207.342,215.303,214.537,218.056,224.939,229.594))
View(consumer)
min<-as.Date("2003-1-1")
max<-as.Date("2012-12-30")
yrs<-as.Date(ISOdate(consumer$year,1,1))
ggplot(data=consumer,aes(x=yrs,y=annual))+
  geom_line(size=1)+
  scale_x_date(limits=c(min,max))+
  xlab("year")+ylab("annual price")