
# Chapter 12
# Example 12.10 page no. 477 from the pdf..
# to predict all possible regression lines 

# refer ex10 page no. 478 on pdf. 

# using leaps library if not installed can be done by 
# install.packages("leaps")

# using sequential replacement method..

library(leaps)

y <- c(57.5,52.8,61.3,67.0,53.5,62.7,56.2,68.5,69.2)

x1 <- c(78,69,77,88,67,80,74,94,102)

x2 <- c(48.2,45.5,46.3,49.0,43.0,48.0,48.0,53.0,58.0)

x3 <- c(2.75,2.15,4.41,5.52,3.21,4.32,2.31,4.30,3.71)


x4 <- c(29.5,26.3,32.2,36.5,27.2,27.7,28.3,30.3,28.7)


dat <- data.frame(y,x1,x2,x3,x4)

s <- regsubsets(y~.,data = dat,method = "seqrep")

print("All possible regression line equation coefficients are")

coef(s,1:4)
 
# for final model we need to see adj r squared value..this is just the coefficients for various variables in the model..

# as nothing specific is asked here so I have shown what would be the model for all combination of variables..

