#Page 381

control_life = c(18, 36, 50, 52, 86, 87, 89, 91,
                 102, 105, 114, 114, 115, 118, 119, 120,
                 149, 160, 165, 166, 167, 167, 173, 178,
                 189, 209, 212, 216, 273, 278, 279, 292,
                 341, 355, 367, 380, 382, 421, 421, 432,
                 446, 455, 463, 474, 506, 515, 546, 559,
                 576, 590, 603, 607, 608, 621, 634, 634,
                 637, 638, 641, 650, 663, 665, 688, 725,
                 735)
dose_1 = c(76, 93, 97, 107, 108, 113, 114, 119,
           136, 137, 138, 139, 152, 154, 154, 160,
           164, 164, 166, 168, 178, 179, 181, 181,
           183, 185, 194, 198, 212, 213, 216, 220,
           225, 225, 244, 253, 256, 259, 265, 268,
           268, 270, 283, 289, 291, 311, 315, 326,
           326, 361, 373, 373, 376, 397, 398, 406,
           452, 466, 592, 598)

dose_2 = c(72, 72, 78, 83, 85, 99, 99, 110,
           113, 113, 114, 114, 118, 119, 123, 124,
           131, 133, 135, 137, 140, 142, 144, 145,
           154, 156, 157, 162, 162, 164, 165, 167,
           171, 176, 177, 181, 182, 187, 192, 196,
           211, 214, 216, 216, 218, 228, 238, 242,
           248, 256, 257, 262, 264, 267, 267, 270,
           286, 303, 309, 324, 326, 334, 335, 358,
           409, 473, 550)

dose_3 = c(10, 33, 44, 56, 59, 72, 74, 77,
           92, 93, 96, 100, 100, 102, 105, 107,
           107, 108, 108, 108, 109, 112, 113, 115,
           116, 120, 121, 122, 122, 124, 130, 134,
           136, 139, 144, 146, 153, 159, 160, 163,
           163, 168, 171, 172, 176, 183, 195, 196,
           197, 202, 213, 215, 216, 222, 230, 231,
           240, 245, 251, 253, 254, 254, 278, 293,
           327, 342, 347, 361, 402, 432, 458, 555)

dose_4 = c(43, 45, 53, 56, 56, 57, 58, 66,
           67, 73, 74, 79, 80, 80, 81, 81,
           81, 82, 83, 83, 84, 88, 89, 91,
           91, 92, 92, 97, 99, 99, 100, 100,
           101, 102, 102, 102, 103, 104, 107, 108,
           109, 113, 114, 118, 121, 123, 126, 128,
           137, 138, 139, 144, 145, 147, 156, 162,
           174, 178, 179, 184, 191, 198, 211, 214,
           243, 249, 329, 380, 403, 511, 522, 598)

dose_5 = c(12, 15, 22, 24, 24, 32, 32, 33,
           34, 38, 38, 43, 44, 48, 52, 53,
           54, 54, 55, 56, 57, 58, 58, 59,
           60, 60, 60, 60, 61, 62, 63, 65,
           65, 67, 68, 70, 70, 72, 73, 75,
           76, 76, 81, 83, 84, 85, 87, 91,
           95, 96, 98, 99, 109, 110, 121, 127,
           129, 131, 143, 146, 146, 175, 175, 211,
           233, 258, 258, 263, 297, 341, 341, 376)

emp_fn_cl = ecdf(control_life)
emp_fn_d1 = ecdf(dose_1)
emp_fn_d2 = ecdf(dose_2)
emp_fn_d3 = ecdf(dose_3)
emp_fn_d4 = ecdf(dose_4)
emp_fn_d5 = ecdf(dose_5)

emp_val_cl = (emp_fn_cl(control_life))
emp_val_d1 = emp_fn_d1(dose_1)
emp_val_d2 = emp_fn_d2(dose_2)
emp_val_d3 = emp_fn_d3(dose_3)
emp_val_d4 = emp_fn_d4(dose_4)
emp_val_d5 = emp_fn_d5(dose_5)

surv_val_cl = 1 - emp_val_cl
surv_val_d1 = 1 - emp_val_d1
surv_val_d2 = 1 - emp_val_d2
surv_val_d3 = 1 - emp_val_d3
surv_val_d4 = 1 - emp_val_d4
surv_val_d5 = 1 - emp_val_d5


plot(x = control_life, y =surv_val_cl, type = "l", xlim = c(0,800))
lines(x = dose_1, y =surv_val_d1, type = "l", xlim = c(0,800), lty = 2, add = TRUE)
lines(x = dose_2, y =surv_val_d2, type = "l", xlim = c(0,800), lty = 3, add = TRUE)
lines(x = dose_3, y =surv_val_d3, type = "l", xlim = c(0,800), lty = 4, add = TRUE)
lines(x = dose_4, y =surv_val_d4, type = "l", xlim = c(0,800), lty = 5, add = TRUE)
lines(x = dose_5, y =surv_val_d5, type = "l", xlim = c(0,800), lty = 6, add = TRUE)